# 安装指南

## 环境要求

- Python 3.9 或更高版本
- pip 包管理器

## 安装步骤

### 1. 克隆项目

```bash
git clone <repository-url>
cd npc-patform
```

### 2. 创建虚拟环境（推荐）

```bash
python -m venv venv

# Windows
venv\Scripts\activate

# Linux/macOS
source venv/bin/activate
```

### 3. 安装依赖

```bash
pip install -r requirements.txt
```

### 4. 配置环境变量

复制 `.env.example` 为 `.env` 并修改配置：

```bash
cp .env.example .env
```

编辑 `.env` 文件，设置服务器配置、数据库连接等信息。

### 5. 启动服务器

```bash
python start_server.py
```

服务器将在 `http://localhost:8080` 启动。

### 6. 启动客户端

#### 命令行客户端

```bash
python start_client.py
```

#### GUI客户端

```bash
python start_client_gui.py
```

## 使用Makefile（可选）

如果系统支持Make，可以使用：

```bash
make install    # 安装依赖
make server     # 启动服务器
make client     # 启动命令行客户端
make client-gui # 启动GUI客户端
make clean      # 清理缓存文件
```

## 配置客户端

首次运行客户端时，需要配置：

1. 服务器地址（例如：`http://localhost:8080`）
2. 客户端ID和Token（需要在服务器端创建客户端获取）

## 常见问题

### 端口被占用

如果8080端口被占用，可以修改 `.env` 文件中的 `PORT` 配置。

### 依赖安装失败

确保使用Python 3.9+，并尝试升级pip：

```bash
pip install --upgrade pip
```

### GUI界面无法启动

确保已安装PyQt6：

```bash
pip install PyQt6
```

