# 部署指南

## 🐳 Docker部署

### 快速启动

```bash
cd docker
docker-compose up -d
```

### 构建自定义镜像

```bash
docker build -t nps-server:latest -f docker/Dockerfile .
```

### 运行容器

```bash
docker run -d \
  --name nps-server \
  -p 8080:8080 \
  -e DATABASE_URL=postgresql://user:pass@host:5432/nps \
  -e REDIS_URL=redis://host:6379/0 \
  -e SECRET_KEY=your-secret-key \
  -v $(pwd)/logs:/app/logs \
  -v $(pwd)/certs:/app/certs \
  nps-server:latest
```

## ☸️ Kubernetes部署

### 1. 创建Secret

```bash
kubectl create secret generic nps-secrets \
  --from-literal=database-url=postgresql://user:pass@postgres:5432/nps \
  --from-literal=redis-url=redis://redis:6379/0 \
  --from-literal=secret-key=your-secret-key
```

### 2. 部署PostgreSQL和Redis

```bash
# 使用Helm或直接部署
kubectl apply -f k8s/postgres.yaml
kubectl apply -f k8s/redis.yaml
```

### 3. 部署NPS服务器

```bash
kubectl apply -f k8s/deployment.yaml
kubectl apply -f k8s/configmap.yaml
```

### 4. 检查状态

```bash
kubectl get pods -l app=nps-server
kubectl logs -f deployment/nps-server
```

## 🔧 配置说明

### 环境变量

| 变量名 | 说明 | 默认值 |
|--------|------|--------|
| HOST | 监听地址 | 0.0.0.0 |
| PORT | 监听端口 | 8080 |
| SECRET_KEY | JWT密钥 | - |
| DATABASE_URL | 数据库URL | - |
| REDIS_URL | Redis URL | - |
| CLUSTER_ENABLED | 启用集群 | false |
| NODE_ID | 节点ID | 自动生成 |
| ACME_EMAIL | Let's Encrypt邮箱 | - |

### 集群配置

```yaml
# config.yaml
cluster:
  enabled: true
  node_id: "node-1"
  heartbeat_interval: 30
  node_timeout: 90

nodes:
  - node_id: "node-1"
    address: "192.168.1.10"
    port: 8080
    role: "master"
  - node_id: "node-2"
    address: "192.168.1.11"
    port: 8080
    role: "worker"
```

## 📊 监控配置

### Prometheus配置

```yaml
# prometheus.yml
scrape_configs:
  - job_name: 'nps'
    kubernetes_sd_configs:
      - role: pod
    relabel_configs:
      - source_labels: [__meta_kubernetes_pod_label_app]
        action: keep
        regex: nps-server
    metrics_path: '/metrics'
```

### Grafana仪表盘

导入Prometheus数据源，创建自定义仪表盘监控：
- 连接数
- 隧道数
- 流量统计
- 系统资源
- 错误率

## 🔒 安全配置

### HTTPS配置

1. 使用Nginx反向代理
2. 配置SSL证书
3. 启用HSTS

### 防火墙规则

```bash
# 只允许必要端口
ufw allow 8080/tcp
ufw allow 22/tcp
ufw enable
```

## 📈 性能调优

### 数据库优化

```sql
-- PostgreSQL配置
shared_buffers = 256MB
effective_cache_size = 1GB
maintenance_work_mem = 64MB
```

### 系统优化

```bash
# 增加文件描述符限制
ulimit -n 65535

# 优化TCP参数
sysctl -w net.core.somaxconn=65535
sysctl -w net.ipv4.tcp_max_syn_backlog=65535
```

## 🚀 生产环境检查清单

- [ ] 配置强密码和密钥
- [ ] 启用HTTPS
- [ ] 配置防火墙规则
- [ ] 设置监控和告警
- [ ] 配置自动备份
- [ ] 启用IP白名单
- [ ] 配置速率限制
- [ ] 设置日志轮转
- [ ] 配置资源限制
- [ ] 测试故障恢复

