# 集群部署指南

## 🎯 集群功能说明

NPS系统现已支持集群部署，实现高可用和负载均衡。

## ✨ 集群特性

### 1. 节点发现和管理 ✅
- 自动节点发现
- 节点心跳检测
- 节点状态监控
- 负载均衡选择

### 2. 会话同步 ✅
- Redis集群会话同步
- 跨节点会话共享
- 自动故障转移

### 3. 负载均衡 ✅
- 基于负载的节点选择
- 连接数均衡
- 自动故障切换

## 🚀 集群部署步骤

### 1. 准备环境

```bash
# 安装PostgreSQL和Redis
docker-compose up -d postgres redis
```

### 2. 配置节点

**节点1配置（主节点）：**
```bash
export NODE_ID=node-1
export CLUSTER_ENABLED=true
export DATABASE_URL=postgresql://user:pass@postgres:5432/nps
export REDIS_URL=redis://redis:6379/0
export SECRET_KEY=shared-secret-key
```

**节点2配置（工作节点）：**
```bash
export NODE_ID=node-2
export CLUSTER_ENABLED=true
export DATABASE_URL=postgresql://user:pass@postgres:5432/nps
export REDIS_URL=redis://redis:6379/0
export SECRET_KEY=shared-secret-key
```

### 3. 启动节点

```bash
# 节点1
python start_server.py

# 节点2（不同端口）
PORT=8081 python start_server.py
```

### 4. 添加节点到集群

```bash
# 在节点1上添加节点2
curl -X POST http://localhost:8080/api/cluster/nodes \
  -H "Content-Type: application/json" \
  -d '{
    "node_id": "node-2",
    "address": "192.168.1.11",
    "port": 8081,
    "role": "worker"
  }'
```

### 5. 查看集群状态

```bash
curl http://localhost:8080/api/cluster/nodes
```

## 📊 集群架构

```
                    ┌─────────────┐
                    │  负载均衡器  │
                    │  (Nginx)    │
                    └──────┬──────┘
                           │
        ┌──────────────────┼──────────────────┐
        │                  │                  │
   ┌────▼────┐       ┌────▼────┐       ┌────▼────┐
   │ Node 1  │       │ Node 2  │       │ Node 3  │
   │ (Master)│       │(Worker) │       │(Worker) │
   └────┬────┘       └────┬────┘       └────┬────┘
        │                 │                  │
        └─────────────────┼──────────────────┘
                          │
        ┌─────────────────┼──────────────────┐
        │                 │                  │
   ┌────▼────┐       ┌────▼────┐
   │PostgreSQL│      │  Redis  │
   └─────────┘       └─────────┘
```

## 🔧 配置说明

### 集群配置

```yaml
# config.yaml
cluster:
  enabled: true
  node_id: "node-1"
  heartbeat_interval: 30  # 心跳间隔（秒）
  node_timeout: 90  # 节点超时（秒）

nodes:
  - node_id: "node-1"
    address: "192.168.1.10"
    port: 8080
    role: "master"
  - node_id: "node-2"
    address: "192.168.1.11"
    port: 8080
    role: "worker"
```

## 📈 监控和告警

### Prometheus配置

```yaml
scrape_configs:
  - job_name: 'nps-cluster'
    static_configs:
      - targets:
        - 'node-1:8080'
        - 'node-2:8080'
        - 'node-3:8080'
```

### Grafana仪表盘

监控指标：
- 集群节点数
- 节点负载
- 连接分布
- 故障节点

## 🔒 安全建议

1. **共享密钥**：所有节点使用相同的SECRET_KEY
2. **网络隔离**：节点间通信使用内网
3. **TLS加密**：启用HTTPS
4. **访问控制**：配置防火墙规则

## 🎯 最佳实践

1. **节点数量**：建议3-5个节点
2. **主节点**：至少1个主节点
3. **负载均衡**：使用Nginx或HAProxy
4. **监控**：配置Prometheus和Grafana
5. **备份**：定期备份数据库

## 🐛 故障排查

### 节点无法加入集群

1. 检查网络连通性
2. 验证节点ID唯一性
3. 检查Redis连接
4. 查看日志：`logs/server.log`

### 会话不同步

1. 检查Redis连接
2. 验证Redis配置
3. 检查网络延迟

### 负载不均衡

1. 检查节点负载指标
2. 验证心跳正常
3. 调整负载均衡策略

