"""
认证管理器测试
"""
import pytest
from server.core.auth.auth_manager import AuthManager
from datetime import datetime, timedelta


@pytest.fixture
def auth_manager():
    """创建认证管理器实例"""
    return AuthManager(secret_key="test_secret_key")


def test_generate_token(auth_manager):
    """测试生成token"""
    token = auth_manager.generate_token("client_123", "Test Client")
    assert token is not None
    assert isinstance(token, str)
    assert len(token) > 0


def test_verify_token(auth_manager):
    """测试验证token"""
    token = auth_manager.generate_token("client_123", "Test Client")
    payload = auth_manager.verify_token(token)
    
    assert payload is not None
    assert payload['client_id'] == "client_123"
    assert payload['client_name'] == "Test Client"


def test_verify_invalid_token(auth_manager):
    """测试验证无效token"""
    payload = auth_manager.verify_token("invalid_token")
    assert payload is None


@pytest.mark.asyncio
async def test_authenticate_client(auth_manager):
    """测试认证客户端"""
    token = auth_manager.generate_token("client_123", "Test Client")
    client = await auth_manager.authenticate_client(token, "client_123")
    
    assert client is not None
    assert client.id == "client_123"
    assert client.name == "Test Client"


@pytest.mark.asyncio
async def test_authenticate_client_invalid_token(auth_manager):
    """测试无效token认证"""
    client = await auth_manager.authenticate_client("invalid_token", "client_123")
    assert client is None


@pytest.mark.asyncio
async def test_authenticate_client_wrong_id(auth_manager):
    """测试错误的客户端ID"""
    token = auth_manager.generate_token("client_123", "Test Client")
    client = await auth_manager.authenticate_client(token, "wrong_client_id")
    assert client is None

