"""
API集成测试
"""
import pytest
from fastapi.testclient import TestClient
from server.main import app


@pytest.fixture
def client():
    """创建测试客户端"""
    return TestClient(app)


def test_root(client):
    """测试根路径"""
    response = client.get("/")
    assert response.status_code == 200
    data = response.json()
    assert "name" in data
    assert data["name"] == "NPS Server"


def test_health_check(client):
    """测试健康检查"""
    response = client.get("/api/health")
    assert response.status_code == 200
    data = response.json()
    assert data["status"] == "healthy"


def test_create_client(client):
    """测试创建客户端"""
    response = client.post(
        "/api/clients",
        json={"name": "Test Client"}
    )
    assert response.status_code == 200
    data = response.json()
    assert "id" in data
    assert "token" in data
    assert data["name"] == "Test Client"


def test_list_clients(client):
    """测试获取客户端列表"""
    # 先创建一个客户端
    client.post("/api/clients", json={"name": "Test Client"})
    
    # 获取列表
    response = client.get("/api/clients")
    assert response.status_code == 200
    data = response.json()
    assert isinstance(data, list)


def test_get_stats(client):
    """测试获取统计信息"""
    response = client.get("/api/stats")
    assert response.status_code == 200
    data = response.json()
    assert "connections" in data
    assert "tunnels" in data
    assert "active_tunnels" in data

