"""
服务器配置
"""
import os
from pydantic_settings import BaseSettings


class Settings(BaseSettings):
    """服务器配置"""
    
    # 服务器配置
    HOST: str = "0.0.0.0"
    PORT: int = 8080
    
    # 安全配置
    SECRET_KEY: str = "your-secret-key-change-in-production"
    
    # 数据库配置
    DATABASE_URL: str = "postgresql://user:password@localhost/nps"
    REDIS_URL: str = "redis://localhost:6379/0"
    
    # 连接配置
    MAX_CONNECTIONS: int = 10000
    HEARTBEAT_TIMEOUT: int = 60
    
    # 日志配置
    LOG_LEVEL: str = "INFO"
    LOG_FILE: str = "logs/server.log"
    
    class Config:
        env_file = ".env"
        case_sensitive = True


settings = Settings()

