#!/bin/bash

# NPS客户端停止脚本
# 使用方法: ./scripts/stop_client.sh

set -e

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 获取脚本所在目录
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_ROOT="$(cd "$SCRIPT_DIR/.." && pwd)"
PID_FILE="$PROJECT_ROOT/logs/client.pid"

echo -e "${BLUE}停止NPS客户端...${NC}"

# 检查PID文件
if [ ! -f "$PID_FILE" ]; then
    echo -e "${YELLOW}⚠ 未找到PID文件，尝试通过进程名查找...${NC}"
    
    # 通过进程名查找
    PIDS=$(pgrep -f "start_client.py\|start_client_gui.py" || true)
    if [ -z "$PIDS" ]; then
        echo -e "${YELLOW}⚠ 未找到运行中的客户端进程${NC}"
        exit 0
    fi
else
    PIDS=$(cat "$PID_FILE")
fi

# 停止进程
for PID in $PIDS; do
    if ps -p $PID > /dev/null 2>&1; then
        echo -e "${YELLOW}正在停止进程 $PID...${NC}"
        kill $PID
        
        # 等待进程结束
        for i in {1..10}; do
            if ! ps -p $PID > /dev/null 2>&1; then
                break
            fi
            sleep 1
        done
        
        # 如果进程仍在运行，强制杀死
        if ps -p $PID > /dev/null 2>&1; then
            echo -e "${YELLOW}进程未响应，强制停止...${NC}"
            kill -9 $PID
        fi
        
        echo -e "${GREEN}✓ 进程 $PID 已停止${NC}"
    else
        echo -e "${YELLOW}⚠ 进程 $PID 不存在${NC}"
    fi
done

# 删除PID文件
if [ -f "$PID_FILE" ]; then
    rm -f "$PID_FILE"
    echo -e "${GREEN}✓ PID文件已删除${NC}"
fi

echo -e "${GREEN}✓ 客户端已停止${NC}"

