#!/bin/bash

# NPS系统一键停止脚本（服务器+客户端）
# 使用方法: ./scripts/stop_all.sh

set -e

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 获取脚本所在目录
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_ROOT="$(cd "$SCRIPT_DIR/.." && pwd)"

echo -e "${BLUE}"
echo "=========================================="
echo "    停止NPS系统"
echo "=========================================="
echo -e "${NC}"

# 停止客户端
echo -e "${YELLOW}停止客户端...${NC}"
bash "$SCRIPT_DIR/stop_client.sh"

echo ""

# 停止服务器
echo -e "${YELLOW}停止服务器...${NC}"
bash "$SCRIPT_DIR/stop_server.sh"

echo ""
echo -e "${GREEN}✓ 所有服务已停止${NC}"

