#!/bin/bash

# NPS客户端GUI一键启动脚本
# 使用方法: ./scripts/start_client_gui.sh

set -e

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 获取脚本所在目录
SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_ROOT="$(cd "$SCRIPT_DIR/.." && pwd)"
cd "$PROJECT_ROOT"

# 打印横幅
echo -e "${BLUE}"
echo "=========================================="
echo "    NPS 客户端启动脚本（GUI）"
echo "=========================================="
echo -e "${NC}"

# 检查Python环境
echo -e "${YELLOW}[1/5] 检查Python环境...${NC}"
if ! command -v python3 &> /dev/null; then
    echo -e "${RED}错误: 未找到Python3，请先安装Python3${NC}"
    exit 1
fi

PYTHON_VERSION=$(python3 --version | cut -d' ' -f2)
echo -e "${GREEN}✓ Python版本: $PYTHON_VERSION${NC}"

# 检查虚拟环境
echo -e "${YELLOW}[2/5] 检查虚拟环境...${NC}"
if [ -d "venv" ]; then
    echo -e "${GREEN}✓ 发现虚拟环境，激活中...${NC}"
    source venv/bin/activate
elif [ -d ".venv" ]; then
    echo -e "${GREEN}✓ 发现虚拟环境，激活中...${NC}"
    source .venv/bin/activate
else
    echo -e "${YELLOW}⚠ 未找到虚拟环境，使用系统Python${NC}"
fi

# 检查GUI依赖
echo -e "${YELLOW}[3/5] 检查GUI依赖...${NC}"
if ! python3 -c "import PyQt6" 2>/dev/null; then
    echo -e "${YELLOW}⚠ PyQt6未安装，正在安装...${NC}"
    pip install PyQt6 -q
fi
echo -e "${GREEN}✓ GUI依赖检查完成${NC}"

# 检查显示环境（Linux）
if [[ "$OSTYPE" == "linux-gnu"* ]]; then
    if [ -z "$DISPLAY" ]; then
        echo -e "${YELLOW}⚠ 未检测到DISPLAY环境变量${NC}"
        echo -e "${YELLOW}提示: 如果使用SSH连接，请使用X11转发: ssh -X user@host${NC}"
    fi
fi

# 创建必要目录
echo -e "${YELLOW}[4/5] 创建必要目录...${NC}"
mkdir -p logs
echo -e "${GREEN}✓ 目录创建完成${NC}"

# 检查配置文件
echo -e "${YELLOW}[5/5] 检查配置文件...${NC}"
if [ ! -f "client/config.yaml" ] && [ ! -f ".env" ]; then
    echo -e "${YELLOW}⚠ 未找到配置文件，GUI启动后请配置客户端信息${NC}"
fi
echo -e "${GREEN}✓ 配置文件检查完成${NC}"

# 启动GUI客户端
echo ""
echo -e "${BLUE}=========================================="
echo "    启动NPS客户端GUI"
echo "=========================================="
echo -e "${NC}"

echo -e "${GREEN}正在启动GUI界面...${NC}"
python3 start_client_gui.py

