# NPS 启动脚本说明

本目录包含NPS系统的所有启动和管理脚本。

## 📋 脚本列表

### 启动脚本

- **start_server.sh** - 启动服务器
- **start_client.sh** - 启动客户端（命令行）
- **start_client_gui.sh** - 启动客户端（GUI）
- **start_all.sh** - 一键启动所有服务

### 停止脚本

- **stop_server.sh** - 停止服务器
- **stop_client.sh** - 停止客户端
- **stop_all.sh** - 一键停止所有服务

### 管理脚本

- **status.sh** - 查看系统状态

## 🚀 使用方法

### 启动服务器

```bash
# 前台运行
./scripts/start_server.sh

# 后台运行
./scripts/start_server.sh --daemon
```

### 启动客户端

```bash
# 命令行客户端（前台）
./scripts/start_client.sh

# 命令行客户端（后台）
./scripts/start_client.sh --daemon

# GUI客户端
./scripts/start_client_gui.sh
```

### 一键启动所有服务

```bash
# 启动服务器和客户端（后台）
./scripts/start_all.sh --daemon

# 仅启动服务器
./scripts/start_all.sh --server-only --daemon

# 仅启动客户端（GUI）
./scripts/start_all.sh --client-only --gui

# 启动服务器和GUI客户端
./scripts/start_all.sh --gui --daemon
```

### 停止服务

```bash
# 停止服务器
./scripts/stop_server.sh

# 停止客户端
./scripts/stop_client.sh

# 停止所有服务
./scripts/stop_all.sh
```

### 查看状态

```bash
./scripts/status.sh
```

## ⚙️ 配置说明

### 环境变量

脚本会自动读取 `.env` 文件中的环境变量，如果没有找到，会使用默认值：

- `HOST` - 服务器监听地址（默认: 0.0.0.0）
- `PORT` - 服务器监听端口（默认: 8080）
- `SECRET_KEY` - JWT密钥（默认: change-me-in-production）
- `DATABASE_URL` - 数据库连接URL
- `REDIS_URL` - Redis连接URL

### 配置文件

客户端需要以下配置文件之一：

- `client/config.yaml` - YAML格式配置文件
- `.env` - 环境变量文件

必需的配置项：
- `client_id` - 客户端ID
- `token` - 客户端Token
- `servers` - 服务器地址列表

## 📁 目录结构

脚本会在项目根目录创建以下目录：

- `logs/` - 日志文件目录
  - `server.log` - 服务器日志
  - `client.log` - 客户端日志
  - `server.pid` - 服务器PID文件
  - `client.pid` - 客户端PID文件
- `certs/` - SSL证书目录
- `backups/` - 备份文件目录

## 🔍 故障排查

### 端口被占用

如果启动时提示端口被占用：

```bash
# 查看端口占用
lsof -i :8080

# 或使用其他端口
PORT=8081 ./scripts/start_server.sh
```

### 依赖未安装

如果提示依赖未安装：

```bash
# 安装依赖
pip install -r requirements.txt
```

### 虚拟环境

脚本会自动检测并激活虚拟环境（`venv` 或 `.venv`），如果没有找到，会使用系统Python。

### 查看日志

```bash
# 服务器日志
tail -f logs/server.log

# 客户端日志
tail -f logs/client.log
```

## 💡 提示

1. **首次使用**：建议先在前台模式运行，确认配置正确后再使用后台模式
2. **生产环境**：建议使用 `--daemon` 参数后台运行
3. **GUI客户端**：需要图形界面支持，SSH连接时需要使用X11转发
4. **权限问题**：确保脚本有执行权限：`chmod +x scripts/*.sh`

## 📝 示例

### 完整启动流程

```bash
# 1. 启动服务器（后台）
./scripts/start_server.sh --daemon

# 2. 等待几秒让服务器启动
sleep 5

# 3. 检查状态
./scripts/status.sh

# 4. 启动客户端（GUI）
./scripts/start_client_gui.sh

# 5. 停止所有服务
./scripts/stop_all.sh
```

### 开发环境快速启动

```bash
# 一键启动服务器和客户端（前台，方便查看日志）
./scripts/start_all.sh
```

### 生产环境部署

```bash
# 后台启动所有服务
./scripts/start_all.sh --daemon

# 查看状态
./scripts/status.sh

# 查看日志
tail -f logs/server.log
tail -f logs/client.log
```

