"""
隧道模型
"""
from enum import Enum
from dataclasses import dataclass
from datetime import datetime
from typing import Optional


class TunnelType(str, Enum):
    """隧道类型"""
    TCP = "tcp"
    HTTP = "http"
    HTTPS = "https"
    UDP = "udp"
    WEBSOCKET = "websocket"


class TunnelStatus(str, Enum):
    """隧道状态"""
    INACTIVE = "inactive"
    ACTIVE = "active"
    ERROR = "error"


@dataclass
class Tunnel:
    """隧道信息"""
    id: str
    client_id: str
    name: str
    tunnel_type: TunnelType
    local_host: str
    local_port: int
    remote_port: Optional[int] = None
    domain: Optional[str] = None
    status: TunnelStatus = TunnelStatus.INACTIVE
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    description: Optional[str] = None
    
    def to_dict(self):
        return {
            'id': self.id,
            'client_id': self.client_id,
            'name': self.name,
            'tunnel_type': self.tunnel_type.value,
            'local_host': self.local_host,
            'local_port': self.local_port,
            'remote_port': self.remote_port,
            'domain': self.domain,
            'status': self.status.value,
            'created_at': self.created_at.isoformat() if self.created_at else None,
            'updated_at': self.updated_at.isoformat() if self.updated_at else None,
            'description': self.description,
        }

