"""
会话模型
"""
from enum import Enum
from dataclasses import dataclass
from datetime import datetime
from typing import Optional


class SessionStatus(str, Enum):
    """会话状态"""
    CONNECTING = "connecting"
    CONNECTED = "connected"
    DISCONNECTED = "disconnected"
    ERROR = "error"


@dataclass
class Session:
    """会话信息"""
    id: str
    client_id: str
    status: SessionStatus
    created_at: datetime
    updated_at: datetime
    remote_addr: Optional[str] = None
    protocol: Optional[str] = None
    
    def to_dict(self):
        return {
            'id': self.id,
            'client_id': self.client_id,
            'status': self.status.value,
            'created_at': self.created_at.isoformat(),
            'updated_at': self.updated_at.isoformat(),
            'remote_addr': self.remote_addr,
            'protocol': self.protocol,
        }

