"""
域名模型
"""
from enum import Enum
from dataclasses import dataclass
from datetime import datetime
from typing import Optional


class DomainStatus(str, Enum):
    """域名状态"""
    PENDING = "pending"
    ACTIVE = "active"
    ERROR = "error"
    EXPIRED = "expired"


@dataclass
class Domain:
    """域名信息"""
    id: str
    domain: str
    client_id: str
    tunnel_id: Optional[str] = None
    ssl_enabled: bool = False
    ssl_cert_path: Optional[str] = None
    ssl_key_path: Optional[str] = None
    status: DomainStatus = DomainStatus.PENDING
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    
    def to_dict(self):
        return {
            'id': self.id,
            'domain': self.domain,
            'client_id': self.client_id,
            'tunnel_id': self.tunnel_id,
            'ssl_enabled': self.ssl_enabled,
            'status': self.status.value,
            'created_at': self.created_at.isoformat() if self.created_at else None,
            'updated_at': self.updated_at.isoformat() if self.updated_at else None,
        }

