"""
客户端模型
"""
from enum import Enum
from dataclasses import dataclass
from datetime import datetime
from typing import Optional


class ClientStatus(str, Enum):
    """客户端状态"""
    OFFLINE = "offline"
    ONLINE = "online"
    DISABLED = "disabled"


@dataclass
class Client:
    """客户端信息"""
    id: str
    name: str
    token: str
    status: ClientStatus
    created_at: datetime
    updated_at: datetime
    last_seen: Optional[datetime] = None
    ip_address: Optional[str] = None
    version: Optional[str] = None
    description: Optional[str] = None
    
    def to_dict(self):
        return {
            'id': self.id,
            'name': self.name,
            'status': self.status.value,
            'created_at': self.created_at.isoformat(),
            'updated_at': self.updated_at.isoformat(),
            'last_seen': self.last_seen.isoformat() if self.last_seen else None,
            'ip_address': self.ip_address,
            'version': self.version,
            'description': self.description,
        }

