# NPS (内网穿透) 系统

基于 Python 开发的内网穿透系统，支持中美网络稳定连接。

## 项目简介

NPS（内网穿透）系统是一个企业级的内网穿透解决方案，专门针对中美网络环境优化，提供稳定、安全、高效的跨洋网络连接服务。

### 核心特性

- ✅ **多协议支持**: WebSocket/TCP/HTTP/UDP
- ✅ **安全认证**: JWT Token认证机制
- ✅ **隧道管理**: 灵活的TCP/HTTP/UDP端口转发
- ✅ **智能重连**: 自动重连和故障恢复
- ✅ **Web管理面板**: FastAPI RESTful API
- ✅ **桌面客户端**: PyQt6图形界面
- ✅ **实时监控**: 连接状态和流量统计
- ✅ **高并发支持**: 支持10,000+并发连接

## 技术栈

### 服务器端
- **语言**: Python 3.9+
- **Web框架**: FastAPI
- **WebSocket**: websockets
- **认证**: JWT (python-jose)
- **日志**: loguru

### 客户端
- **语言**: Python 3.9+
- **GUI框架**: PyQt6
- **异步IO**: asyncio
- **WebSocket**: websockets
- **配置管理**: PyYAML

## 快速开始

### 1. 安装依赖

```bash
# 克隆项目
git clone <repository-url>
cd npc-patform

# 创建虚拟环境（推荐）
python -m venv venv
source venv/bin/activate  # Linux/macOS
# 或 venv\Scripts\activate  # Windows

# 安装依赖
pip install -r requirements.txt
```

### 2. 配置环境

复制并编辑环境配置文件：

```bash
cp .env.example .env
# 编辑 .env 文件设置服务器配置
```

### 3. 启动服务器

```bash
python start_server.py
```

服务器将在 `http://localhost:8080` 启动。

访问 `http://localhost:8080/docs` 查看API文档。

### 4. 创建客户端

通过API创建客户端：

```bash
curl -X POST http://localhost:8080/api/clients \
  -H "Content-Type: application/json" \
  -d '{"name": "My Client"}'
```

返回的响应包含 `id` 和 `token`，用于客户端配置。

### 5. 启动客户端

#### 命令行客户端

```bash
python start_client.py
```

#### GUI客户端（推荐）

```bash
python start_client_gui.py
```

在GUI界面中配置：
- 服务器地址: `http://localhost:8080`
- 客户端ID和Token（从步骤4获取）

### 6. 创建隧道

通过API创建隧道：

```bash
curl -X POST http://localhost:8080/api/clients/{client_id}/tunnels \
  -H "Content-Type: application/json" \
  -d '{
    "name": "SSH Tunnel",
    "tunnel_type": "tcp",
    "local_host": "127.0.0.1",
    "local_port": 22,
    "remote_port": 2222
  }'
```

## 项目结构

```
npc-patform/
├── common/              # 公共模块
│   ├── models/         # 数据模型
│   ├── protocol/       # 通信协议
│   └── utils/          # 工具函数
├── server/             # 服务器端
│   ├── core/          # 核心模块（网关/认证/隧道）
│   ├── api/           # Web API
│   └── main.py        # 服务器入口
├── client/            # 客户端
│   ├── core/         # 核心模块（连接/代理/配置）
│   ├── gui/          # GUI界面
│   └── main.py       # 客户端入口
├── start_server.py    # 启动服务器
├── start_client.py    # 启动客户端（CLI）
├── start_client_gui.py # 启动客户端（GUI）
└── requirements.txt   # 依赖包
```

详细结构说明请查看 [PROJECT_STRUCTURE.md](PROJECT_STRUCTURE.md)

## API文档

启动服务器后，访问以下地址查看API文档：

- Swagger UI: `http://localhost:8080/docs`
- ReDoc: `http://localhost:8080/redoc`

### 主要API端点

- `GET /api/clients` - 获取客户端列表
- `POST /api/clients` - 创建客户端
- `GET /api/clients/{client_id}/tunnels` - 获取客户端隧道列表
- `POST /api/clients/{client_id}/tunnels` - 创建隧道
- `DELETE /api/tunnels/{tunnel_id}` - 删除隧道
- `GET /api/stats` - 获取统计信息
- `WS /api/ws` - WebSocket连接端点

## 使用Makefile（可选）

```bash
make install    # 安装依赖
make server     # 启动服务器
make client     # 启动命令行客户端
make client-gui # 启动GUI客户端
make clean      # 清理缓存文件
```

## 开发计划

根据 `requirmants.md` 中的详细计划，项目分阶段实施：

1. ✅ **第一阶段**: 核心框架开发（已完成）
2. ⏳ **第二阶段**: 核心功能完善（进行中）
3. ⏳ **第三阶段**: 高级特性开发
4. ⏳ **第四阶段**: 测试和优化

## 文档

- [安装指南](INSTALL.md)
- [项目结构说明](PROJECT_STRUCTURE.md)
- [需求文档](requirmants.md)

## 许可证

[待定]

## 贡献

欢迎提交Issue和Pull Request！

## 联系方式

[待定]

