# 快速启动指南

## 🚀 一键启动脚本

NPS系统提供了便捷的一键启动脚本，支持服务器和客户端的快速启动和管理。

## 📋 脚本列表

| 脚本 | 说明 | 用法 |
|------|------|------|
| `start_server.sh` | 启动服务器 | `./scripts/start_server.sh [--daemon]` |
| `start_client.sh` | 启动客户端（命令行） | `./scripts/start_client.sh [--daemon]` |
| `start_client_gui.sh` | 启动客户端（GUI） | `./scripts/start_client_gui.sh` |
| `start_all.sh` | 一键启动所有服务 | `./scripts/start_all.sh [选项]` |
| `stop_server.sh` | 停止服务器 | `./scripts/stop_server.sh` |
| `stop_client.sh` | 停止客户端 | `./scripts/stop_client.sh` |
| `stop_all.sh` | 停止所有服务 | `./scripts/stop_all.sh` |
| `status.sh` | 查看系统状态 | `./scripts/status.sh` |

## 🎯 快速开始

### 1. 首次使用

```bash
# 1. 确保脚本有执行权限
chmod +x scripts/*.sh

# 2. 安装依赖
pip install -r requirements.txt

# 3. 配置环境变量（可选）
cp .env.example .env
# 编辑 .env 文件

# 4. 启动服务器（前台，方便查看日志）
./scripts/start_server.sh
```

### 2. 生产环境部署

```bash
# 后台启动服务器
./scripts/start_server.sh --daemon

# 等待服务器启动
sleep 5

# 检查状态
./scripts/status.sh

# 启动客户端（后台）
./scripts/start_client.sh --daemon

# 查看日志
tail -f logs/server.log
tail -f logs/client.log
```

### 3. 开发环境

```bash
# 一键启动服务器和客户端（前台）
./scripts/start_all.sh

# 或分别启动（方便调试）
./scripts/start_server.sh
# 在另一个终端
./scripts/start_client.sh
```

### 4. GUI客户端

```bash
# 启动GUI客户端
./scripts/start_client_gui.sh

# 或使用一键启动
./scripts/start_all.sh --gui
```

## 📝 常用命令

### 启动服务

```bash
# 服务器（前台）
./scripts/start_server.sh

# 服务器（后台）
./scripts/start_server.sh --daemon

# 客户端（命令行，前台）
./scripts/start_client.sh

# 客户端（命令行，后台）
./scripts/start_client.sh --daemon

# 客户端（GUI）
./scripts/start_client_gui.sh

# 一键启动所有（后台）
./scripts/start_all.sh --daemon
```

### 停止服务

```bash
# 停止服务器
./scripts/stop_server.sh

# 停止客户端
./scripts/stop_client.sh

# 停止所有服务
./scripts/stop_all.sh
```

### 查看状态

```bash
# 查看系统状态
./scripts/status.sh
```

### 查看日志

```bash
# 服务器日志
tail -f logs/server.log

# 客户端日志
tail -f logs/client.log

# 实时查看所有日志
tail -f logs/*.log
```

## ⚙️ 配置说明

### 环境变量

脚本会自动读取 `.env` 文件，如果没有找到，会使用默认值：

```bash
# .env 文件示例
HOST=0.0.0.0
PORT=8080
SECRET_KEY=your-secret-key-here
DATABASE_URL=postgresql://user:pass@localhost:5432/nps
REDIS_URL=redis://localhost:6379/0
CLUSTER_ENABLED=false
NODE_ID=node-1
```

### 客户端配置

客户端需要以下配置之一：

**方式一：环境变量**

```bash
export CLIENT_ID=your-client-id
export CLIENT_TOKEN=your-token
export SERVERS=ws://server1:8080,ws://server2:8080
```

**方式二：配置文件**

创建 `client/config.yaml`:

```yaml
client:
  id: your-client-id
  token: your-token
  servers:
    - ws://server1:8080
    - ws://server2:8080
```

## 🔍 故障排查

### 端口被占用

```bash
# 查看端口占用
lsof -i :8080

# 使用其他端口
PORT=8081 ./scripts/start_server.sh
```

### 权限问题

```bash
# 添加执行权限
chmod +x scripts/*.sh
```

### 依赖未安装

```bash
# 安装依赖
pip install -r requirements.txt

# 或使用虚拟环境
python -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

### 虚拟环境

脚本会自动检测并激活虚拟环境（`venv` 或 `.venv`），如果没有找到，会使用系统Python。

### 查看详细日志

```bash
# 服务器详细日志
tail -f logs/server.log

# 客户端详细日志
tail -f logs/client.log

# 查看错误
grep ERROR logs/*.log
```

## 💡 提示

1. **首次使用**：建议在前台模式运行，确认配置正确后再使用后台模式
2. **生产环境**：使用 `--daemon` 参数后台运行，并配置日志轮转
3. **GUI客户端**：需要图形界面支持，SSH连接时使用 `ssh -X`
4. **多服务器**：客户端支持多服务器配置，自动选择最优服务器
5. **集群模式**：服务器支持集群部署，设置 `CLUSTER_ENABLED=true`

## 📚 更多信息

- [完整文档](README.md)
- [安装指南](INSTALL.md)
- [部署指南](DEPLOYMENT.md)
- [集群指南](CLUSTER_GUIDE.md)
- [脚本说明](scripts/README.md)

