# 快速开始指南

## 5分钟快速上手

### 步骤1: 安装依赖

```bash
# 创建虚拟环境（推荐）
python -m venv venv
source venv/bin/activate  # Linux/macOS
# 或 venv\Scripts\activate  # Windows

# 安装依赖
pip install -r requirements.txt
```

### 步骤2: 启动服务器

```bash
python start_server.py
```

服务器将在 `http://localhost:8080` 启动。

### 步骤3: 创建客户端

打开新的终端窗口，使用API创建客户端：

```bash
curl -X POST http://localhost:8080/api/clients \
  -H "Content-Type: application/json" \
  -d '{"name": "测试客户端"}'
```

保存返回的 `id` 和 `token`。

### 步骤4: 启动客户端GUI

```bash
python start_client_gui.py
```

在GUI界面中：
1. 输入服务器地址: `http://localhost:8080`
2. 输入客户端ID和Token（从步骤3获取）
3. 点击"连接"按钮

### 步骤5: 创建隧道

通过API创建隧道（将 `{client_id}` 替换为实际的客户端ID）：

```bash
curl -X POST http://localhost:8080/api/clients/{client_id}/tunnels \
  -H "Content-Type: application/json" \
  -d '{
    "name": "SSH隧道",
    "tunnel_type": "tcp",
    "local_host": "127.0.0.1",
    "local_port": 22,
    "remote_port": 2222
  }'
```

### 步骤6: 测试连接

现在可以通过 `localhost:2222` 访问本地的SSH服务（端口22）。

## 常用命令

### 查看API文档

启动服务器后访问：
- Swagger UI: http://localhost:8080/docs
- ReDoc: http://localhost:8080/redoc

### 查看客户端列表

```bash
curl http://localhost:8080/api/clients
```

### 查看统计信息

```bash
curl http://localhost:8080/api/stats
```

### 删除隧道

```bash
curl -X DELETE http://localhost:8080/api/tunnels/{tunnel_id}
```

## 配置文件

客户端配置文件位置：`config.yaml`

首次运行客户端时会自动创建，包含：
- 服务器地址
- 客户端ID和Token
- 隧道配置列表

## 故障排查

### 服务器无法启动

1. 检查端口8080是否被占用
2. 修改 `.env` 文件中的 `PORT` 配置

### 客户端无法连接

1. 确认服务器正在运行
2. 检查服务器地址是否正确
3. 验证客户端ID和Token是否正确

### GUI界面无法启动

确保已安装PyQt6：
```bash
pip install PyQt6
```

## 下一步

- 阅读 [README.md](README.md) 了解完整功能
- 查看 [PROJECT_STRUCTURE.md](PROJECT_STRUCTURE.md) 了解项目结构
- 阅读 [requirmants.md](requirmants.md) 了解详细需求

