# 项目结构说明

## 目录结构

```
npc-patform/
├── common/                      # 公共模块
│   ├── models/                  # 数据模型
│   │   ├── client.py           # 客户端模型
│   │   ├── tunnel.py           # 隧道模型
│   │   ├── domain.py           # 域名模型
│   │   └── session.py          # 会话模型
│   ├── protocol/                # 通信协议
│   │   └── message.py          # 消息协议定义
│   └── utils/                   # 工具函数
│       ├── crypto.py           # 加密工具
│       └── logger.py           # 日志工具
│
├── server/                      # 服务器端
│   ├── core/                   # 核心模块
│   │   ├── gateway/           # 连接网关
│   │   │   ├── connection_manager.py    # 连接管理器
│   │   │   └── websocket_handler.py     # WebSocket处理器
│   │   ├── auth/              # 认证授权
│   │   │   └── auth_manager.py         # 认证管理器
│   │   ├── tunnel/            # 隧道管理
│   │   │   ├── tunnel_manager.py       # 隧道管理器
│   │   │   ├── forward_engine.py       # 转发引擎（TCP/HTTP）
│   │   │   └── udp_proxy.py            # UDP代理
│   │   ├── domain/            # 域名管理
│   │   │   ├── domain_manager.py       # 域名管理器
│   │   │   ├── ssl_manager.py          # SSL证书管理
│   │   │   └── acme_client.py          # ACME客户端
│   │   ├── stats/             # 统计模块
│   │   │   └── traffic_stats.py        # 流量统计
│   │   ├── monitor/           # 监控模块
│   │   │   └── monitor.py              # 系统监控
│   │   ├── monitoring/        # Prometheus监控
│   │   │   └── prometheus_metrics.py   # Prometheus指标
│   │   ├── cluster/           # 集群管理
│   │   │   ├── node_manager.py         # 节点管理
│   │   │   └── session_sync.py         # 会话同步
│   │   ├── security/          # 安全模块
│   │   │   ├── ip_filter.py            # IP过滤
│   │   │   ├── rate_limiter.py         # 速率限制
│   │   │   └── anomaly_detector.py     # 异常检测
│   │   ├── quota/             # 配额管理
│   │   │   └── quota_manager.py       # 配额管理器
│   │   ├── cache/             # 缓存管理
│   │   │   └── cache_manager.py       # 缓存管理器
│   │   ├── backup/            # 备份管理
│   │   │   └── backup_manager.py      # 备份管理器
│   │   ├── api_auth/          # API认证
│   │   │   └── api_auth.py            # API认证管理器
│   │   └── performance/       # 性能分析
│   │       └── profiler.py             # 性能分析器
│   ├── api/                    # Web API
│   │   ├── routes.py          # API路由
│   │   └── websocket_broadcast.py  # WebSocket广播
│   ├── db/                     # 数据库
│   │   ├── database.py        # 数据库连接
│   │   ├── models.py          # ORM模型
│   │   └── repositories.py    # 数据访问层
│   ├── web/                    # Web管理面板
│   │   └── static/            # 静态文件
│   │       ├── index.html     # 主页面
│   │       ├── css/           # 样式文件
│   │       └── js/            # JavaScript文件
│   ├── config.py              # 服务器配置
│   └── main.py                # 服务器入口
│
├── client/                     # 客户端
│   ├── core/                  # 核心模块
│   │   ├── connection/       # 连接管理
│   │   │   └── connection_manager.py    # 连接管理器
│   │   ├── proxy/            # 本地代理
│   │   │   └── local_proxy.py          # 本地代理服务
│   │   └── config/           # 配置管理
│   │       └── config_manager.py       # 配置管理器
│   ├── gui/                  # GUI界面
│   │   └── main_window.py    # 主窗口
│   └── main.py               # 客户端入口
│
├── scripts/                  # 启动脚本
│   ├── start_server.sh       # 服务器启动脚本
│   ├── start_client.sh       # 客户端启动脚本
│   ├── start_client_gui.sh   # GUI客户端启动脚本
│   ├── start_all.sh          # 一键启动所有服务
│   ├── stop_server.sh        # 停止服务器
│   ├── stop_client.sh        # 停止客户端
│   ├── stop_all.sh           # 停止所有服务
│   ├── status.sh             # 查看系统状态
│   └── README.md             # 脚本使用说明
├── docker/                   # Docker部署
│   ├── Dockerfile            # Docker镜像
│   └── docker-compose.yml    # Docker Compose配置
├── k8s/                      # Kubernetes部署
│   ├── deployment.yaml      # Deployment配置
│   └── configmap.yaml        # ConfigMap配置
├── tests/                    # 测试文件
│   ├── conftest.py          # pytest配置
│   ├── test_*.py            # 单元测试
│   └── integration/         # 集成测试
├── start_server.py           # 启动服务器脚本（Python）
├── start_client.py           # 启动客户端脚本（Python）
├── start_client_gui.py       # 启动GUI客户端脚本（Python）
├── requirements.txt          # Python依赖包
├── alembic.ini              # Alembic配置
├── Makefile                  # Make命令
├── README.md                 # 项目说明
├── INSTALL.md                # 安装指南
├── QUICK_START.md            # 快速启动指南
├── DEPLOYMENT.md             # 部署指南
├── CLUSTER_GUIDE.md          # 集群部署指南
└── .gitignore               # Git忽略文件
```

## 核心模块说明

### 服务器端 (server/)

#### 1. 连接网关 (core/gateway/)
- **ConnectionManager**: 管理所有客户端连接，支持最大10000并发连接
- **WebSocketHandler**: 处理WebSocket连接，包括认证、消息路由等

#### 2. 认证授权 (core/auth/)
- **AuthManager**: 基于JWT的认证系统，支持token生成和验证

#### 3. 隧道管理 (core/tunnel/)
- **TunnelManager**: 管理所有隧道，支持TCP/HTTP/UDP/WebSocket等类型
- **ForwardEngine**: TCP/HTTP转发引擎，支持双向数据转发和HTTP反向代理
- **UDPProxy**: UDP代理实现，支持UDP数据包转发
- 自动端口分配和管理
- 隧道状态管理（激活/停用）

#### 4. 域名管理 (core/domain/)
- **DomainManager**: 域名绑定和管理
- **SSLManager**: SSL证书管理，支持自动申请和续期
- **ACMEClient**: ACME协议客户端，支持Let's Encrypt证书

#### 5. 统计和监控 (core/stats/, core/monitor/, core/monitoring/)
- **TrafficStats**: 流量统计，记录客户端和隧道的流量数据
- **SystemMonitor**: 系统监控，监控CPU、内存、磁盘、网络等
- **PrometheusMetrics**: Prometheus指标导出，支持Grafana可视化

#### 6. 集群管理 (core/cluster/)
- **NodeManager**: 节点管理，支持节点发现、心跳检测、负载均衡
- **SessionSync**: Redis会话同步，支持跨节点会话共享

#### 7. 安全模块 (core/security/)
- **IPFilter**: IP白名单/黑名单过滤
- **RateLimiter**: API速率限制
- **AnomalyDetector**: 异常检测和DDoS防护

#### 8. 其他模块
- **QuotaManager**: 配额管理（流量、连接、时间）
- **CacheManager**: 缓存管理（内存缓存，TTL支持）
- **BackupManager**: 数据备份和恢复
- **APIAuth**: API认证和权限管理（JWT、RBAC）
- **PerformanceProfiler**: 性能分析和优化工具

#### 9. Web API (api/)
- RESTful API接口（55+端点）
- 客户端管理（CRUD）
- 隧道管理（CRUD、启动/停止）
- 域名管理（CRUD）
- SSL证书管理（申请、续期）
- 流量统计和监控
- 系统健康检查
- 集群管理
- API认证和权限控制
- WebSocket实时推送

#### 10. 数据库 (db/)
- PostgreSQL数据库支持
- SQLAlchemy ORM
- Alembic数据库迁移
- 数据持久化（客户端、隧道、域名、会话等）

#### 11. Web管理面板 (web/)
- 现代化Web界面
- 实时数据更新（WebSocket）
- 客户端管理界面
- 隧道管理界面
- 统计和监控仪表盘

### 客户端 (client/)

#### 1. 连接管理 (core/connection/)
- **ClientConnectionManager**: 管理与服务器的连接
- 自动重连机制
- 心跳保持

#### 2. 本地代理 (core/proxy/)
- **LocalProxy**: 本地服务代理
- 支持TCP/HTTP/UDP代理
- 数据转发到服务器

#### 3. 配置管理 (core/config/)
- **ConfigManager**: YAML配置文件管理
- 客户端信息存储
- 隧道配置管理

#### 4. GUI界面 (gui/)
- **MainWindow**: PyQt6桌面应用
- 连接管理界面
- 隧道管理界面
- 日志查看界面

## 通信协议

### 消息类型

- `AUTH_REQUEST`: 认证请求
- `AUTH_RESPONSE`: 认证响应
- `HEARTBEAT`: 心跳
- `TUNNEL_CREATE`: 创建隧道
- `TUNNEL_DATA`: 隧道数据
- `CONTROL`: 控制消息

### 消息格式

```json
{
    "type": "message_type",
    "id": "message_id",
    "data": {},
    "timestamp": 1234567890.0
}
```

## 数据模型

### Client (客户端)
- id: 客户端ID
- name: 客户端名称
- token: 认证token
- status: 状态（online/offline/disabled）

### Tunnel (隧道)
- id: 隧道ID
- client_id: 所属客户端ID
- tunnel_type: 隧道类型（tcp/http/udp/websocket）
- local_host: 本地主机
- local_port: 本地端口
- remote_port: 远程端口
- status: 状态（active/inactive/error）

### Session (会话)
- id: 会话ID
- client_id: 客户端ID
- status: 状态（connected/disconnected）
- remote_addr: 远程地址

## 使用流程

1. **启动服务器**
   ```bash
   # 使用启动脚本（推荐）
   ./scripts/start_server.sh
   
   # 或直接运行Python脚本
   python start_server.py
   ```

2. **创建客户端**（通过API）
   ```bash
   curl -X POST http://localhost:8080/api/clients \
     -H "Content-Type: application/json" \
     -d '{"name": "My Client"}'
   ```

3. **配置客户端**
   - 编辑 `config.yaml` 或使用GUI界面
   - 设置服务器地址、客户端ID和Token

4. **启动客户端**
   ```bash
   # 使用启动脚本（推荐）
   ./scripts/start_client.sh          # 命令行
   ./scripts/start_client_gui.sh     # GUI
   
   # 或直接运行Python脚本
   python start_client.py             # 命令行
   python start_client_gui.py         # GUI
   
   # 一键启动所有服务
   ./scripts/start_all.sh --daemon
   ```

5. **创建隧道**（通过API或GUI）
   ```bash
   curl -X POST http://localhost:8080/api/clients/{client_id}/tunnels \
     -H "Content-Type: application/json" \
     -d '{
       "name": "SSH Tunnel",
       "tunnel_type": "tcp",
       "local_host": "127.0.0.1",
       "local_port": 22,
       "remote_port": 2222
     }'
   ```

## 开发计划

根据 `requirmants.md` 中的计划，项目已分阶段实施：

1. ✅ **第一阶段**: 核心框架开发（已完成）
2. ✅ **第二阶段**: 核心功能完善（已完成）
   - TCP/UDP/HTTP代理实现
   - 域名管理和SSL证书自动申请
   - 流量统计和监控
   - Web管理面板前端
   - 数据库持久化
3. ✅ **第三阶段**: 高级特性开发（已完成）
   - 集群部署支持
   - 安全防护（IP过滤、速率限制、异常检测）
   - 配额管理
   - 缓存机制
   - 备份恢复
   - API认证和权限管理
   - 性能分析工具
4. ⏳ **第四阶段**: 测试和优化（进行中）
   - 单元测试和集成测试
   - 性能优化
   - 文档完善

## 技术栈

### 服务器端
- **语言**: Python 3.9+
- **Web框架**: FastAPI
- **WebSocket**: websockets
- **数据库**: PostgreSQL + SQLAlchemy + Alembic
- **缓存**: Redis
- **监控**: Prometheus
- **SSL**: Let's Encrypt (ACME)
- **日志**: loguru

### 客户端
- **语言**: Python 3.9+
- **GUI框架**: PyQt6
- **异步IO**: asyncio
- **WebSocket**: websockets
- **配置管理**: PyYAML

### 部署
- **容器化**: Docker + Docker Compose
- **编排**: Kubernetes
- **脚本**: Shell脚本（一键启动/停止）

## 已完成功能

- [x] ✅ **完善TCP/UDP/HTTP代理实现**
  - `server/core/tunnel/forward_engine.py` - TCP/HTTP转发引擎
  - `server/core/tunnel/udp_proxy.py` - UDP代理实现
  - 支持双向数据转发和HTTP反向代理

- [x] ✅ **实现域名管理和SSL证书自动申请**
  - `server/core/domain/domain_manager.py` - 域名管理
  - `server/core/domain/ssl_manager.py` - SSL证书管理
  - `server/core/domain/acme_client.py` - ACME协议客户端（Let's Encrypt）

- [x] ✅ **添加流量统计和监控**
  - `server/core/stats/traffic_stats.py` - 流量统计
  - `server/core/monitor/monitor.py` - 系统监控
  - `server/core/monitoring/prometheus_metrics.py` - Prometheus指标

- [x] ✅ **实现Web管理面板前端**
  - `server/web/static/index.html` - 管理面板HTML
  - `server/web/static/css/style.css` - 样式文件
  - `server/web/static/js/main.js` - 主JavaScript
  - `server/web/static/js/websocket.js` - WebSocket实时推送

- [x] ✅ **添加数据库持久化**
  - `server/db/database.py` - 数据库连接管理
  - `server/db/models.py` - ORM模型定义
  - `server/db/repositories.py` - 数据访问层
  - 支持PostgreSQL和Alembic迁移

- [x] ✅ **实现集群部署支持**
  - `server/core/cluster/node_manager.py` - 节点管理
  - `server/core/cluster/session_sync.py` - Redis会话同步
  - 支持多节点部署和负载均衡

## 下一步开发

- [x] ✅ **性能优化和压力测试** - 已完成
  - 连接池优化（数据库、HTTP）
  - 数据库查询优化
  - 缓存策略优化
  - 性能基准测试和压力测试工具

- [x] ✅ **完善单元测试和集成测试覆盖率** - 已完成
  - 单元测试覆盖核心模块
  - 集成测试覆盖API和关键功能
  - 性能测试和压力测试

- [x] ✅ **添加更多监控指标和告警规则** - 已完成
  - 扩展Prometheus指标（30+）
  - 告警规则引擎（10+规则）
  - Grafana仪表盘配置

- [x] ✅ **实现API限流和熔断机制** - 已完成
  - API限流器（滑动窗口、令牌桶）
  - 熔断器（三种状态管理）
  - 限流和熔断中间件

- [x] ✅ **添加更多安全特性** - 已完成
  - IP白名单/黑名单
  - DDoS防护
  - HTTPS自动配置
  - 防火墙规则管理
  - 安全审计
  - 密钥轮换
  - 日志审计
  - 备份加密

- [x] ✅ **完善文档和示例代码** - 已完成
  - 性能优化指南
  - 安全指南
  - 使用示例
  - API客户端示例
  - WebSocket客户端示例

## 新增功能

- [x] ✅ **更多协议支持** - SOCKS5、FTP、SSH等
- [x] ✅ **监控仪表盘** - Grafana仪表盘配置
- [x] ✅ **日志分析工具** - 增强的日志分析功能
- [x] ✅ **自动化部署** - CI/CD配置

