# 企业级功能说明

## 🚀 本次升级新增的企业级功能

### 1. 安全增强 ✅

#### IP过滤（白名单/黑名单）
- 支持IP地址和CIDR格式
- 白名单模式：只允许白名单IP访问
- 黑名单模式：拒绝黑名单IP访问
- 动态添加/移除

**API端点：**
- `POST /api/security/whitelist` - 添加白名单
- `DELETE /api/security/whitelist/{ip}` - 移除白名单
- `GET /api/security/whitelist` - 获取白名单
- `POST /api/security/blacklist` - 添加黑名单
- `DELETE /api/security/blacklist/{ip}` - 移除黑名单
- `GET /api/security/blacklist` - 获取黑名单

#### 速率限制
- 基于IP和端点的速率限制
- 可配置的请求限制和时间窗口
- 自动返回429状态码和Retry-After头

**API端点：**
- `POST /api/security/rate-limit` - 设置速率限制

**使用示例：**
```bash
# 设置API端点速率限制：每分钟100次请求
curl -X POST http://localhost:8080/api/security/rate-limit \
  -H "Content-Type: application/json" \
  -d '{
    "key": "api:/api/clients",
    "max_requests": 100,
    "window_seconds": 60
  }'
```

#### 异常检测
- 连接频率检测
- 失败认证检测
- 异常行为识别
- 自动告警

**API端点：**
- `GET /api/security/anomalies` - 获取异常事件

### 2. Prometheus监控集成 ✅

- 完整的Prometheus指标导出
- 连接数、隧道数、流量统计
- HTTP请求指标
- 系统资源指标
- 错误和认证指标

**访问地址：**
- `GET /metrics` - Prometheus指标端点

**指标列表：**
- `nps_connections_total` - 总连接数
- `nps_connections_active` - 活跃连接数
- `nps_tunnels_total` - 总隧道数
- `nps_tunnels_active` - 活跃隧道数
- `nps_traffic_bytes_total` - 总流量（字节）
- `nps_http_requests_total` - HTTP请求总数
- `nps_http_request_duration_seconds` - HTTP请求耗时
- `nps_errors_total` - 错误总数
- `nps_auth_attempts_total` - 认证尝试总数
- `nps_system_cpu_percent` - CPU使用率
- `nps_system_memory_bytes` - 内存使用量

**Grafana配置示例：**
```yaml
# prometheus.yml
scrape_configs:
  - job_name: 'nps'
    static_configs:
      - targets: ['localhost:8080']
```

### 3. 告警通知系统 ✅

- 邮件通知
- Webhook通知
- 自定义处理器
- 多级别告警（info/warning/error/critical）

**配置邮件通知：**
```python
alert_manager.configure_email(
    smtp_host="smtp.example.com",
    smtp_port=587,
    username="user@example.com",
    password="password",
    from_email="nps@example.com",
    to_emails=["admin@example.com"]
)
```

**添加Webhook：**
```python
alert_manager.add_webhook("https://hooks.example.com/webhook")
```

**API端点：**
- `GET /api/alerts` - 获取告警列表

### 4. 配置热重载 ✅

- 自动监控配置文件变更
- 无需重启服务即可应用新配置
- 支持回调函数处理配置变更

**使用方式：**
```python
config_reloader = ConfigReloader("config.yaml")
config_reloader.load_config()

# 添加配置变更回调
def on_config_changed(old_config, new_config):
    print("配置已更新")

config_reloader.add_reload_callback(on_config_changed)
config_reloader.start_watching()
```

### 5. 数据备份和恢复 ✅

- 自动备份配置文件
- 数据库备份（PostgreSQL）
- 证书文件备份
- 备份元数据管理
- 一键恢复功能

**API端点：**
- `POST /api/backups` - 创建备份
- `GET /api/backups` - 列出所有备份
- `POST /api/backups/{name}/restore` - 恢复备份
- `DELETE /api/backups/{name}` - 删除备份

**使用示例：**
```bash
# 创建备份
curl -X POST http://localhost:8080/api/backups \
  -H "Content-Type: application/json" \
  -d '{"name": "backup_20240101"}'

# 列出备份
curl http://localhost:8080/api/backups

# 恢复备份
curl -X POST http://localhost:8080/api/backups/backup_20240101/restore
```

## 🔒 安全最佳实践

### 1. IP白名单配置

```bash
# 添加可信IP到白名单
curl -X POST http://localhost:8080/api/security/whitelist \
  -H "Content-Type: application/json" \
  -d '{"ip_or_cidr": "192.168.1.0/24"}'

# 启用白名单模式（只允许白名单IP）
# 在代码中调用：ip_filter.enable_whitelist(True)
```

### 2. 速率限制配置

```bash
# 限制API访问频率
curl -X POST http://localhost:8080/api/security/rate-limit \
  -H "Content-Type: application/json" \
  -d '{
    "key": "api:all",
    "max_requests": 1000,
    "window_seconds": 60
  }'
```

### 3. 黑名单管理

```bash
# 添加恶意IP到黑名单
curl -X POST http://localhost:8080/api/security/blacklist \
  -H "Content-Type: application/json" \
  -d '{"ip_or_cidr": "1.2.3.4"}'
```

## 📊 监控和告警配置

### Prometheus + Grafana

1. **配置Prometheus**
```yaml
# prometheus.yml
global:
  scrape_interval: 15s

scrape_configs:
  - job_name: 'nps'
    metrics_path: '/metrics'
    static_configs:
      - targets: ['localhost:8080']
```

2. **Grafana仪表盘**
- 导入Prometheus数据源
- 创建自定义仪表盘
- 配置告警规则

### 告警规则示例

```yaml
# prometheus告警规则
groups:
  - name: nps_alerts
    rules:
      - alert: HighConnectionCount
        expr: nps_connections_active > 8000
        for: 5m
        annotations:
          summary: "连接数过高"
      
      - alert: HighErrorRate
        expr: rate(nps_errors_total[5m]) > 10
        for: 5m
        annotations:
          summary: "错误率过高"
```

## 🛡️ DDoS防护

系统已内置多层防护：

1. **IP过滤** - 阻止恶意IP
2. **速率限制** - 限制请求频率
3. **异常检测** - 识别异常行为
4. **连接限制** - 最大连接数限制

## 📈 性能优化

1. **缓存机制** - 减少数据库查询
2. **异步处理** - 提高并发性能
3. **连接池** - 优化数据库连接
4. **指标监控** - 实时性能追踪

## 🔄 备份策略

### 自动备份

建议配置定时任务：

```bash
# crontab -e
# 每天凌晨2点自动备份
0 2 * * * curl -X POST http://localhost:8080/api/backups
```

### 备份保留策略

- 保留最近30天的每日备份
- 保留最近12个月的每月备份
- 自动清理过期备份

## 🎯 企业级部署建议

1. **高可用部署**
   - 多节点部署
   - 负载均衡
   - 数据库主从复制

2. **安全加固**
   - 启用HTTPS
   - 配置防火墙规则
   - 定期安全审计

3. **监控告警**
   - Prometheus + Grafana
   - 告警通知集成
   - 日志集中管理

4. **备份恢复**
   - 自动化备份
   - 异地备份
   - 定期恢复测试

## 📝 配置示例

### 完整的安全配置

```yaml
# config.yaml
security:
  ip_filter:
    whitelist_enabled: false
    blacklist_enabled: true
    whitelist:
      - "192.168.1.0/24"
      - "10.0.0.0/8"
    blacklist:
      - "1.2.3.4"
  
  rate_limit:
    default:
      max_requests: 1000
      window_seconds: 60
    api:
      max_requests: 100
      window_seconds: 60

monitoring:
  prometheus:
    enabled: true
    path: "/metrics"
  
  alerts:
    email:
      enabled: true
      smtp_host: "smtp.example.com"
      smtp_port: 587
      from: "nps@example.com"
      to: ["admin@example.com"]
    webhooks:
      - "https://hooks.example.com/webhook"

backup:
  enabled: true
  schedule: "0 2 * * *"  # 每天凌晨2点
  retention_days: 30
```

## ✨ 总结

系统现已具备完整的企业级功能：

✅ 多层安全防护
✅ Prometheus监控集成
✅ 告警通知系统
✅ 配置热重载
✅ 数据备份恢复
✅ 异常检测
✅ 速率限制
✅ IP过滤

系统已准备好用于生产环境部署！

